from launch import LaunchDescription
from launch_ros.actions import Node
from launch.substitutions import LaunchConfiguration
from launch.actions import DeclareLaunchArgument

def generate_launch_description():
    return LaunchDescription([
        DeclareLaunchArgument('points_topic', default_value='/ouster/points'),
        DeclareLaunchArgument('turn_signal_topic', default_value='/vehicle/turn_signal_cmd'),
        DeclareLaunchArgument('radius_feet', default_value='5.0'),
        DeclareLaunchArgument('turn_signal_mode', default_value='RIGHT'),
        Node(
            package='ouster_alarm',
            executable='alarm_node',
            name='ouster_proximity_alarm',
            parameters=[{
                'points_topic': LaunchConfiguration('points_topic'),
                'turn_signal_topic': LaunchConfiguration('turn_signal_topic'),
                'radius_feet': LaunchConfiguration('radius_feet'),
                'turn_signal_mode': LaunchConfiguration('turn_signal_mode'),
            }, 'config/alarm.yaml'],
            output='screen',
        ),
    ])
