from launch import LaunchDescription
from launch.actions import DeclareLaunchArgument
from launch.substitutions import LaunchConfiguration
from launch_ros.actions import Node

from ament_index_python.packages import get_package_share_directory
import os

def generate_launch_description():
    pkg_share = get_package_share_directory('ouster_alarm')
    default_params = os.path.join(pkg_share, 'config', 'alarm.yaml')

    return LaunchDescription([
        DeclareLaunchArgument('points_topic', default_value='/ouster/points'),
        DeclareLaunchArgument('misc_topic', default_value='/vehicle/misc_cmd'),
        DeclareLaunchArgument('radius_feet', default_value='5.0'),
        DeclareLaunchArgument('turn_signal_mode', default_value='RIGHT'),

        # optional: allow overriding the params file from CLI
        DeclareLaunchArgument('misc_topic', default_value='/vehicle/misc_cmd'),

        Node(
            package='ouster_alarm',
            executable='alarm_node',
            name='ouster_proximity_alarm',
            parameters=[
                {
                    'points_topic': LaunchConfiguration('points_topic'),
                    'misc_topic': LaunchConfiguration('misc_topic'),
                    'radius_feet': LaunchConfiguration('radius_feet'),
                    'turn_signal_mode': LaunchConfiguration('turn_signal_mode'),
                },
                LaunchConfiguration('params_file'),
            ],
            output='screen',
        ),
    ])
