from setuptools import setup


package_name = 'ouster_alarm'


setup(
    name=package_name,
    version='0.1.0',
    packages=[package_name],
    data_files=[
        ('share/ament_index/resource_index/packages', ['resource/' + package_name]),
        ('share/' + package_name, ['package.xml']),
        ('share/' + package_name + '/launch', ['launch/alarm.launch.py']),
        ('share/' + package_name + '/config', ['config/alarm.yaml']),
        ('share/' + package_name, ['readme.md']),
],
install_requires=['setuptools'],
zip_safe=True,
maintainer='ouster_alarm',
maintainer_email='user@example.com',
description='Trigger a turn signal when motion is detected near the LiDAR',
license='MIT',
tests_require=['pytest'],
entry_points={
    'console_scripts': [
        'alarm_node = ouster_alarm.alarm_node:main',
        ],
    },
)